C
C =====================================================================
C ========================== G E T S T R ==============================
C =====================================================================
C
      SUBROUTINE GETSTR(I_OUT)
C
C =====================================================================
C I                                                                   I
C I   SUBROUTINE GETSTR ASSEMBELS THE GLOBAL STIFFNESS MATRIX AND/OR  I
C I   STORES THE NODE NUMBERS OF THE CURRENT ELEMENT AND THE POSITION I
C I   OF THE ELEMENT MATRICES IN THE GLOBAL MATRICES.                 I
C I                                                                   I
C I                                                                   I
C I   II(J)    POSITION OF LOCAL STIFFNESS TERMS IN THE GLOBAL        I
C I            STIFFNESS MATRIX.                                      I
C I                                                                   I
C I   SKG(I) =    GLOBAL STIFFNESS MATRIX IN THE CONDENSED FORM       I
C I   SK(I,J)  =    ELEMENT STIFFNESS MATRIX                          I
C I                 (SK IS COMPUTED BY SUBPROGRAM STIFEL)             I
C I                                                                   I
C I                                                                   I
C =====================================================================
C
      IMPLICIT NONE
      INTEGER MAX_ELEMENTS,MAX_ELEM_NODES,MAX_ELEM_STIFF,MNNDF
      INTEGER STRS_STRN_REL,AXISYMMETRIC
      PARAMETER (AXISYMMETRIC=3)
      PARAMETER (MAX_ELEMENTS=400,MAX_ELEM_NODES=20,MAX_ELEM_STIFF=60)
      PARAMETER (MNNDF=3)
      INTEGER ELNUM,ELEM_TYPE,SAVED_ETYPE,I1,I2,IDIM,INCREMENTS
      INTEGER ISTART,ITERATIONS,I_OUT,K,K1,K2,LINES,MATNUM,NCB,NELEM
      INTEGER NINODE,NNDF,II,NOP,NNODES,NNEL,NRB,NIP,INTCOD
      INTEGER NIPXI,NIPETA,NIPSI
      REAL*8 THICK
      LOGICAL LINEAR,SYMMETRIC
      COMMON/INPUT8/NNODES,NELEM,NNDF,INCREMENTS,ITERATIONS,LINEAR,
     .              SYMMETRIC,IDIM,NINODE
      COMMON/INPUT9/THICK,STRS_STRN_REL
      COMMON/INPUT1/NIPXI,NIPETA,NIPSI,NIP,INTCOD
      COMMON/INPUT2/NOP(MAX_ELEM_NODES,MAX_ELEMENTS)
      COMMON/ASSEM2/II(MAX_ELEM_STIFF)
C
C           NCB = NUMBER OF COLUMNS IN THE <B> MATRIX.
C           NRB = NUMBER OF ROWS IN THE <B> MATRIX.
C           NNEL = NUMBER OF NODES IN THE ELEMENT.
C
      SAVED_ETYPE = 0
      DO ELNUM = 1 , NELEM
        CALL ELINFO(ELNUM,ELEM_TYPE,NNEL,MATNUM,STRS_STRN_REL,
     .              ISTART,LINES)
        IF (ELEM_TYPE.NE.SAVED_ETYPE) THEN
          IF (ELEM_TYPE.GT.300) THEN
            NCB = 3*NNEL
            NRB = 6
            IF (INTCOD.GE.140) THEN
              CALL ISH3DI(ELEM_TYPE,NNEL)
            ELSE
              CALL ISH3DG(ELEM_TYPE,NNEL)
            END IF
          ELSE
            NCB = 2*NNEL
            CALL ISH2DG(ELEM_TYPE,NNEL)
            IF (STRS_STRN_REL.EQ.AXISYMMETRIC) THEN
              NRB = 4
            ELSE
              NRB = 3
            END IF
          END IF
        END IF
        SAVED_ETYPE = ELEM_TYPE
        DO K1 = 1 , NNEL
          I1 = NNDF*(K1 - 1)
          I2 = NNDF*(NOP(K1 , ELNUM) - 1)
          DO K2 = 1 , NNDF
            K = I1 + K2
            II( K ) = I2 + K2
          END DO
        END DO
C
C              GEOMETRICALLY NONLINEAR PROBLEMS
C
        IF(.NOT.LINEAR) THEN
          IF(ELEM_TYPE.GT.300) THEN
            CALL S3DNS(ELNUM,ELEM_TYPE,NNEL,NRB,NCB,NIP,MATNUM,I_OUT)
          ELSE
            CALL S2DNS(ELNUM,ELEM_TYPE,NNEL,NRB,NCB,NIP,MATNUM,I_OUT)
          ENDIF
C
C              GEOMETRICALLY LINEAR PROBLEMS
C
        ELSE IF(LINEAR) THEN
          IF(ELEM_TYPE.GT.300) THEN
            CALL S3DLS(ELNUM,ELEM_TYPE,NNEL,NRB,NCB,NIP,MATNUM,I_OUT)
          ELSE
            CALL S2DLS(ELNUM,ELEM_TYPE,NNEL,NRB,NCB,NIP,MATNUM,I_OUT)
          ENDIF
        ENDIF
      END DO
C
      END
C
C =====================================================================
C =========================== E L S T R ===============================
C =====================================================================
C
      SUBROUTINE ELSTR
C
C =====================================================================
C I                                                                   I
C I      SUBPROGRAM ELSTR EVALUATES THE STIFFNESS MATRIX OF EACH ELEM I
C I                                                                   I
C I      ENTRY POINTS:                                                I
C I      S2DLS   : FOR 2D PLANE STRESS, PLANE STRAIN AND AXISYMMETRIC I
C I               PROBLEMS WITHOUT GEOMETRIC NONLINEARITY.            I
C I                                                                   I
C I      S2DNS : FOR 2D PLANE STRESS, PLANE STRAIN AND AXISYMMETRIC   I
C I               PROBLEMS WITH GEOMETRIC NONLINEARITY.               I
C I                                                                   I
C I      S3DLS   : FOR 3D STRAIN FIELDS WITHOUT GEOM. NONLINEARITY    I
C I                                                                   I
C I      S3DNS : FOR 3D STRAIN FIELDS WITH GEOMETRIC NONLINEARITY     I
C I                                                                   I
C I                                                                   I
C I  PARAMETER LIST:                                                  I
C I                                                                   I
C I   STRS_STRN_REL = 1(PLANE_STRESS): PLANE STRESS PROBLEM (ES2DLS , I
C I                                    ES2DNS ONLY)                   I
C I                   2(PLANE_STRAIN): PLANE STRAIN PROBLEM (ES2DLS , I
C I                                    ES2DNS ONLY)                   I
C I                   3(AXISYMMETRIC): AXISYMMETRIC PROBLEM (ES2DLS , I
C I                                    ES2DNS ONLY)                   I
C I                                                                   I
C I      ELNUM     = ELEMENT NUMBER                                   I
C I      NNEL      = NUMBER OF NODES IN THE ELEMENT                   I
C I      NRB       = NUMBER OF ROWS OF THE <B> MATRIX                 I
C I      NCB       = NUMBER OF COLUMNS OF THE <B> MATRIX              I
C I      NIP       = TOTAL NUMBER OF INTEGRATION POINTS IN THE ELEM.  I
C I                                                                   I
C I                                                                   I
C I                                                                   I
C =====================================================================
C
      IMPLICIT NONE
      INTEGER MAX_NODES,MAX_ELEM_NODES,MAX_GAUSS_PTS,MAX_ELEM_STIFF,
     .        MNNDF,MAX_NODES_DOF
      INTEGER STRS_STRN_REL,AXISYMMETRIC
      INTEGER EVAL_STRESS
      PARAMETER (EVAL_STRESS=1)
      PARAMETER (AXISYMMETRIC=3)
      PARAMETER (MAX_NODES=3000,MAX_ELEM_NODES=20,MAX_GAUSS_PTS=27,
     .           MAX_ELEM_STIFF=60,MNNDF=3,
     .           MAX_NODES_DOF=MAX_NODES*MNNDF)
      REAL*8 N,NXI,NETA,NSI,NX,NY,NZ,A5,CST,DETJAC,RAD,THICK
      REAL*8 DUDX,DVDX,DWDX,DUDY,DVDY,DWDY,DUDZ,DVDZ,DWDZ
      REAL*8 STRN,UTOTAL,W,ZERO,HALF
      INTEGER ELNUM,ELEM_TYPE,INTGPN,I_OUT,K1,K11,K12,K13,MATNUM,NCB
      INTEGER NIP,NNEL,NRB,II
      COMMON/ISHAP2/W(MAX_GAUSS_PTS)
      COMMON/ISHAP1/N(MAX_ELEM_NODES,MAX_GAUSS_PTS),
     .              NXI(MAX_ELEM_NODES,MAX_GAUSS_PTS),
     .              NETA(MAX_ELEM_NODES,MAX_GAUSS_PTS),
     .              NSI(MAX_ELEM_NODES,MAX_GAUSS_PTS)
      COMMON/MAIN2/UTOTAL(MAX_NODES_DOF)
      COMMON/ASSEM2/II(MAX_ELEM_STIFF)
      COMMON/JACOB1/NX(MAX_ELEM_NODES),NY(MAX_ELEM_NODES),
     .              NZ(MAX_ELEM_NODES)
      COMMON/B2/DUDX,DVDX,DWDX,DUDY,DVDY,DWDY,DUDZ,DVDZ,DWDZ,A5
      COMMON/INPUT9/THICK,STRS_STRN_REL
      COMMON/ELSTR1/STRN(6)
C
      DATA ZERO,HALF /0.0D0,0.5D0/
C
C ======================== E N T R Y    S 2 D L S =====================
C
      ENTRY S2DLS (ELNUM,ELEM_TYPE,NNEL,NRB,NCB,NIP,MATNUM,I_OUT)
      DO INTGPN = 1 , NIP
        CALL JACB2D(INTGPN,ELNUM,NNEL,DETJAC)
        IF(STRS_STRN_REL.EQ.AXISYMMETRIC)
     .                 CALL AXISYM(INTGPN,ELNUM,NNEL,RAD,THICK)
        CALL B2DLS(INTGPN,NNEL,RAD)
        CST = DETJAC*THICK*W( INTGPN )
        DUDX = ZERO
        DVDX = ZERO
        DUDY = ZERO
        DVDY = ZERO
        A5 = ZERO
        DO K1 = 1,NNEL
          K12 = 2*K1
          K11 = K12 - 1
          DUDX = DUDX + NX(K1)*UTOTAL(II(K11))
          DVDX = DVDX + NX(K1)*UTOTAL(II(K12))
          DUDY = DUDY + NY(K1)*UTOTAL(II(K11))
          DVDY = DVDY + NY(K1)*UTOTAL(II(K12))
          A5 = A5 + N(K1,INTGPN)*UTOTAL(II(K11))
        END DO
        STRN( 1 ) = DUDX
        STRN( 2 ) = DVDY
        STRN( 3 ) = DUDY + DVDX
        STRN( 4 ) = ZERO
        IF (STRS_STRN_REL.EQ.AXISYMMETRIC) STRN( 4 ) = A5/RAD
        CALL MATMOD(ELNUM,ELEM_TYPE,MATNUM,INTGPN,STRS_STRN_REL,
     .              I_OUT,EVAL_STRESS)
        CALL EQUILB(CST,NCB,NRB)
      END DO
      RETURN
C
C ======================== E N T R Y    S 2 D N S =====================
C
      ENTRY S2DNS (ELNUM,ELEM_TYPE,NNEL,NRB,NCB,NIP,MATNUM,I_OUT)
      DO INTGPN = 1 , NIP
        CALL JACB2D(INTGPN,ELNUM,NNEL,DETJAC)
        IF(STRS_STRN_REL.EQ.AXISYMMETRIC)
     .                  CALL AXISYM(INTGPN,ELNUM,NNEL,RAD,THICK)
        CALL B2DNS(INTGPN,NNEL,RAD)
        CST = DETJAC*THICK*W( INTGPN )
        STRN(1)=DUDX+HALF*(DUDX**2 + DVDX**2 )
        STRN(2)=DVDY+HALF*(DUDY**2 + DVDY**2 )
        STRN(3)=DUDY+DVDX + DUDX*DUDY + DVDX*DVDY
        STRN(4)=ZERO
        IF (STRS_STRN_REL.EQ.AXISYMMETRIC) STRN(4)=A5+HALF*(A5**2)
        CALL MATMOD(ELNUM,ELEM_TYPE,MATNUM,INTGPN,STRS_STRN_REL,I_OUT,
     .              EVAL_STRESS)
        CALL EQUILB(CST,NCB,NRB)
      END DO
      RETURN
C
C ======================== E N T R Y    S 3 D L S =====================
C
      ENTRY S3DLS (ELNUM,ELEM_TYPE,NNEL,NRB,NCB,NIP,MATNUM,I_OUT)
      DO INTGPN = 1 , NIP
        CALL JACB3D(INTGPN,ELNUM,NNEL,DETJAC)
        CALL B3DLS(NNEL)
        CST = DETJAC*W( INTGPN )
        DUDX = ZERO
        DVDX = ZERO
        DWDX = ZERO
        DUDY = ZERO
        DVDY = ZERO
        DWDY = ZERO
        DUDZ = ZERO
        DVDZ = ZERO
        DWDZ = ZERO
        DO K1 = 1,NNEL
          K13 = 3*K1
          K12 = K13 - 1
          K11 = K13 - 2
          DUDX = DUDX + NX(K1)*UTOTAL(II(K11))
          DVDX = DVDX + NX(K1)*UTOTAL(II(K12))
          DWDX = DWDX + NX(K1)*UTOTAL(II(K13))
          DUDY = DUDY + NY(K1)*UTOTAL(II(K11))
          DVDY = DVDY + NY(K1)*UTOTAL(II(K12))
          DWDY = DWDY + NY(K1)*UTOTAL(II(K13))
          DUDZ = DUDZ + NZ(K1)*UTOTAL(II(K11))
          DVDZ = DVDZ + NZ(K1)*UTOTAL(II(K12))
          DWDZ = DWDZ + NZ(K1)*UTOTAL(II(K13))
        END DO
        STRN( 1 ) = DUDX
        STRN( 2 ) = DVDY
        STRN( 3 ) = DWDZ
        STRN( 4 ) = DUDY + DVDX
        STRN( 5 ) = DWDY + DVDZ
        STRN( 6 ) = DWDX + DUDZ
        CALL MATMOD(ELNUM,ELEM_TYPE,MATNUM,INTGPN,STRS_STRN_REL,
     .              I_OUT,EVAL_STRESS)
        CALL EQUILB(CST,NCB,NRB)
      END DO
      RETURN
C
C ======================== E N T R Y    S 3 D N S =====================
C
      ENTRY S3DNS (ELNUM,ELEM_TYPE,NNEL,NRB,NCB,NIP,MATNUM,I_OUT)
      DO INTGPN = 1 , NIP
        CALL JACB3D(INTGPN,ELNUM,NNEL,DETJAC)
        CALL B3DNS(NNEL)
        CST = DETJAC*W( INTGPN )
        STRN(1)=DUDX+HALF*(DUDX**2+DVDX**2+DWDX**2)
        STRN(2)=DVDY+HALF*(DUDY**2+DVDY**2+DWDY**2)
        STRN(3)=DWDZ+HALF*(DUDZ**2+DVDZ**2+DWDZ**2)
        STRN( 4 ) = DUDY + DVDX + DUDX*DUDY + DVDX*DVDY + DWDX*DWDY
        STRN( 5 ) = DWDY + DVDZ + DUDZ*DUDY + DVDZ*DVDY + DWDZ*DWDY
        STRN( 6 ) = DWDX + DUDZ + DUDZ*DUDX + DVDZ*DVDX + DWDZ*DWDX
        CALL MATMOD(ELNUM,ELEM_TYPE,MATNUM,INTGPN,STRS_STRN_REL,
     .              I_OUT,EVAL_STRESS)
        CALL EQUILB(CST,NCB,NRB)
      END DO
C
      END
C
C =====================================================================
C ========================= E Q U L I B ===============================
C =====================================================================
C
      SUBROUTINE EQUILB(CST,NCB,NRB)
      IMPLICIT NONE
      INTEGER MAX_NODES,MAX_ELEM_STIFF,MNNDF,MAX_NODES_DOF
      PARAMETER (MAX_NODES=3000,MAX_ELEM_STIFF=60,MNNDF=3,
     .           MAX_NODES_DOF=MAX_NODES*MNNDF)
      REAL*8 B,RE,STRS,CST,TEMP,ZERO
      INTEGER K1,K2,NCB,NRB,II
      COMMON/ASSEM2/II(MAX_ELEM_STIFF)
      COMMON/ELSTR2/STRS(6)
      COMMON/MAIN4/RE(MAX_NODES_DOF)
      COMMON/B1/B(6,MAX_ELEM_STIFF)
C
      DATA ZERO /0.0D0/
C
      DO K1 = 1 , NCB
        TEMP = ZERO
        DO K2 = 1 , NRB
          TEMP = TEMP + B(K2 , K1)*STRS( K2 )
        END DO
        RE(II(K1)) = RE(II(K1)) + TEMP*CST
      END DO
C
      END
